cat("*********************************************************************\n");
#############################################################################
# To load data for cluster ensembling algorithms
#############################################################################
#The following is for UCI Soybean dataset
# Number of classes     4
# Number of features    35
# Number of instances   47=10+10+10+17
#############################################################################
if(F){
cat("UCI Soybean\n");
x<-read.table(file="soybeansmall",header=FALSE,sep=",",strip.white=FALSE);
#We stipulate   x$label<--true label
#while          x$cluster<--cluster ID
#x$label<-x$Species;
x$label<-x$V36;
sp<-matrix(0,nrow(x),1);
sp[x$label=="D1"]<-"1";
sp[x$label=="D2"]<-"2";
sp[x$label=="D3"]<-"3";
sp[x$label=="D4"]<-"4";
tmp<-c("V36");
rmcls<-match(tmp,names(x));
x<-x[,-rmcls];
nc<-4;
m<-35;
}


#######################################################################
# The following is for UCI image segmentation (test set) data
# Number of classes     7
# Number of features    19
# Number of instances   2100=300*7
#######################################################################
if(F){
cat("UCI Image Segmentation\n");
x<-read.table(file="segTest",header=FALSE,sep=",",strip.white=FALSE);
x$label<-x$V1;
sp<-matrix(0,nrow(x),1);
sp[x$label=="GRASS"]<-"1";
sp[x$label=="PATH"]<-"2";
sp[x$label=="WINDOW"]<-"3";
sp[x$label=="CEMENT"]<-"4";
sp[x$label=="FOLIAGE"]<-"5";
sp[x$label=="SKY"]<-"6";
sp[x$label=="BRICKFACE"]<-"7";
tmp<-c("V1");
rmcls<-match(tmp,names(x));
x<-x[,-rmcls];
nc<-7;
m<-19;
}

#######################################################################
# The following is for UCI SPECT data
# classes       2
# features      22
# instances     267=212+55
#######################################################################
if(F){
cat("UCI SPECT dataset\n");
x<-read.table(file="spect",header=FALSE,sep=",",strip.white=FALSE);
x$label<-x$V1;
sp<-matrix(0,nrow(x),1);
sp[x$label=="1"]<-"1";
sp[x$label=="0"]<-"2";
tmp<-c("V1");
rmcls<-match(tmp,names(x));
x<-x[,-rmcls];
nc<-2;
m<-22;
}


#######################################################################
# The following is for UCI(Statlog) Heart data
# classes       2
# features      13
# instances     270=150+120
#######################################################################
if(F){
cat("UCI Heart dataset\n");
x<-read.table(file="heart",header=FALSE,sep="",strip.white=FALSE);
x$label<-x$V14;
sp<-matrix(0,nrow(x),1);
sp[x$label=="1"]<-"1";
sp[x$label=="2"]<-"2";
tmp<-c("V14");
rmcls<-match(tmp,names(x));
x<-x[,-rmcls];
nc<-2;
m<-13;
}


#######################################################################
# The following is for UCI Wine data
# classes       3
# features      13
# instances     178=59+71+48
#######################################################################
if(F){
cat("UCI Wine dataset\n");
x<-read.table(file="wine",header=FALSE,sep=",",strip.white=FALSE);
x$label<-x$V1;
sp<-matrix(0,nrow(x),1);
sp[x$label=="1"]<-"1";
sp[x$label=="2"]<-"2";
sp[x$label=="3"]<-"3";
tmp<-c("V1");
rmcls<-match(tmp,names(x));
x<-x[,-rmcls];
nc<-3;
m<-13;
}


#######################################################################
# The following is for UCI Wisconsin Breast Cancer data
# classes       2
# features      30
# instances     569=357+212
#######################################################################
if(F){
cat("UCI WDBC dataset\n");
x<-read.table(file="wdbc",header=FALSE,sep=",",strip.white=FALSE);
x$label<-x$V2;
sp<-matrix(0,nrow(x),1);
sp[x$label=="M"]<-"1";
sp[x$label=="B"]<-"2";
tmp<-c("V1","V2");
rmcls<-match(tmp,names(x));
x<-x[,-rmcls];
nc<-2;
m<-30;
}



#######################################################################
# The following is for UCI Madelon data
# classes       2
# features      500
# instances     2000=1000+1000
#######################################################################
if(F){
cat("UCI Madlon dataset\n");
x<-read.table(file="madelon.data",header=FALSE,sep="",strip.white=FALSE);
y<-read.table(file="madelon.labels",header=FALSE,sep="",strip.white=FALSE);
x$label<-y[,1];
sp<-matrix(0,nrow(x),1);
sp[x$label=="1"]<-"1";
sp[x$label=="2"]<-"2";
##tmp<-c("V1","V2");
##rmcls<-match(tmp,names(x));
##x<-x[,-rmcls];
nc<-2;
m<-500;
}


#######################################################################
# The following is for UCI Robotics data (lp5)
# classes       5
# features      90
# instances     164
# 		27%+16%+13%+29%+16%
#######################################################################
if(F){
cat("UCI Robotics dataset (lp5)\n");
x<-read.table(file="lp5.Rdata",header=FALSE,sep="",strip.white=FALSE);
x$label<-x[,1];
sp<-matrix(0,nrow(x),1);
sp[x$label=="C1"]<-"1";
sp[x$label=="C2"]<-"2";
sp[x$label=="C3"]<-"3";
sp[x$label=="C4"]<-"4";
sp[x$label=="C5"]<-"5";
tmp<-c("V1");
rmcls<-match(tmp,names(x));
x<-x[,-rmcls];
nc<-5;
m<-90;
}

#######################################################################
## Naval plants data (11934x18)
## 		# Features=16, #instances=11934, #classes=2
#######################################################################
if(F){
x<-read.table("NavalPlants.Data.txt",sep="");
n<-nrow(x); p<-ncol(x);
q3Compressor<-quantile(x[,p-1],0.5);
q3Turbine<-quantile(x[,p],0.5);
sp<-matrix(1,nrow(x),1);
for(i in 1:nrow(x))
{
	if(x[i,p-1]< q3Compressor & x[i,p] <q3Turbine) sp[i]<-2; ##No maintenance required
}
x<-x[,1:(p-2)]; nc<-2;
m<-16; x$label<-sp;
}##End of if(F)


#######################################################################
## Remote sensing (Canton)
## 		# Features=56, #instances=3303, #classes=7
#######################################################################
if(F){
x<-read.table("rsCanton.Data", header=FALSE, sep=",");
N<-nrow(x); 

##Consolidating classes
y<-matrix(0,N,1); y<-as.character(x[,1]);
spt<-matrix(0,N,1);
spt[y=="forestA"]<-1; spt[y=="forestB"]<-1; spt[y=="forest"]<-1; 
spt[y=="bareland1"]<-2; spt[y=="bareland2"]<-2; spt[y=="bareland"]<-2; 
spt[y=="industryA"]<-3; spt[y=="industryB"]<-3; spt[y=="industry"]<-3; 
spt[y=="industryC"]<-3; spt[y=="industryD"]<-3;
spt[y=="water"]<-4; spt[y=="idle"]<-5;
spt[y=="orchard"]<-6;  spt[y=="residential"]<-7;
spt[y=="cropland1"]<-8; spt[y=="cropland2"]<-8; 
spt[y=="farmland"]<-9;

##Remove 'cropland' and 'farmland' from the data
idx<-(1:N)[spt==8]; x<-x[-idx,]; spt<-spt[-idx];
N<-nrow(x); idx<-(1:N)[spt==9]; x<-x[-idx,]; spt<-spt[-idx];
sp<-spt;

x<-x[,-1];
n<-nrow(x); nc<-7;
m<-ncol(x);
}


#########################################################################
# UCI Musk dataset
# Number of classes     2
# Number of features    166 (originally 168 but the first not used)
# Number of instances    6598
#             musks(15.41%)+non(84.59%)
#########################################################################
##if(F){
cat("* UCI Musk (6598)\n");
tmp<-read.table(file="musk.Rdata",header=FALSE,sep=",",strip.white=FALSE);

##x$label<-x$V169;
sp<-matrix(0,nrow(tmp),1);
sp[tmp[,169]=="1"]<-"1";
sp[tmp[,169]=="0"]<-"2";

x<-tmp[,-c(1,2,169)];
n<-nrow(x); p<-ncol(x);
nc<-2;
m<-ncol(x); x$label<-sp;
##}



######################################################################
# To output information about the dataset
######################################################################
cat("*  # Data points = ",nrow(x),"\n");
cat("*  # Features =",m,"\n");
cat("*  # Classes=",nc,"\n");
cat("*********************************************************************\n");
cat("Finished data loading......\n\n");


######################################################################
# Now call the clustering program
######################################################################
z<-clusterForestsWrapper(x,sp,ncluster=nc,m);
